/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.handler;

import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.config.BlockCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorStandItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EndCrystalItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class VanillaItemHandler {
    public static boolean isTool(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return item instanceof TieredItem || item instanceof FlintAndSteelItem || item instanceof ShearsItem || DynamicCrosshair.config.getAdditionalTools().contains(item);
    }

    public static boolean isThrowable(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return item instanceof EggItem || item instanceof SnowballItem || item instanceof ThrowablePotionItem || item instanceof ExperienceBottleItem || item instanceof EnderpearlItem || DynamicCrosshair.config.getAdditionalThrowables().contains(item);
    }

    public static boolean isShield(ItemStack itemStack) {
        return itemStack.m_41720_().m_6164_(itemStack) == UseAnim.BLOCK;
    }

    public static boolean isMeleeWeapon(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return item instanceof SwordItem || DynamicCrosshair.config.getAdditionalMeleeWeapons().contains(item);
    }

    public static boolean isRangedWeapon(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof FishingRodItem) {
            return true;
        }
        if (DynamicCrosshair.config.getAdditionalRangedWeapons().contains(item)) {
            return true;
        }
        return switch (item.m_6164_(itemStack)) {
            case UseAnim.BOW, UseAnim.CROSSBOW, UseAnim.SPEAR -> true;
            default -> false;
        };
    }

    public static boolean isBlockItem(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return item instanceof BlockItem || item instanceof ArmorStandItem || item instanceof MinecartItem || item instanceof BoatItem || item instanceof EndCrystalItem;
    }

    public static Crosshair checkTool(CrosshairContext context) {
        Item handItem = context.getItem();
        if (handItem instanceof TieredItem || handItem instanceof FlintAndSteelItem || handItem instanceof ShearsItem || DynamicCrosshair.config.getAdditionalTools().contains(handItem)) {
            return Crosshair.TOOL;
        }
        if (handItem instanceof FishingRodItem) {
            if (context.player.f_36083_ == null) {
                return Crosshair.RANGED_WEAPON;
            }
            return Crosshair.USABLE;
        }
        return null;
    }

    public static Crosshair checkThrowable(CrosshairContext context) {
        Item handItem = context.getItem();
        if (handItem instanceof EggItem || handItem instanceof SnowballItem || handItem instanceof ThrowablePotionItem || handItem instanceof ExperienceBottleItem || handItem instanceof EnderpearlItem || DynamicCrosshair.config.getAdditionalThrowables().contains(handItem)) {
            return Crosshair.THROWABLE;
        }
        return null;
    }

    public static Crosshair checkShield(CrosshairContext context) {
        if (context.getItem().m_6164_(context.getItemStack()) == UseAnim.BLOCK) {
            return Crosshair.SHIELD;
        }
        return null;
    }

    public static Crosshair checkMeleeWeapon(CrosshairContext context) {
        Item handItem = context.getItem();
        if (handItem instanceof SwordItem) {
            if (context.canUseWeaponAsTool()) {
                BlockState blockState = context.getBlockState();
                if (handItem.m_8102_(context.getItemStack(), blockState) > 1.0f && handItem.m_6777_(blockState, (Level)context.world, context.getBlockPos(), (Player)context.player)) {
                    return null;
                }
            }
            return Crosshair.MELEE_WEAPON;
        }
        if (handItem instanceof TridentItem) {
            return Crosshair.MELEE_WEAPON;
        }
        if (handItem instanceof AxeItem) {
            if (context.canUseWeaponAsTool()) {
                return null;
            }
            return Crosshair.MELEE_WEAPON;
        }
        if (DynamicCrosshair.config.getAdditionalMeleeWeapons().contains(handItem)) {
            return Crosshair.MELEE_WEAPON;
        }
        return null;
    }

    public static Crosshair checkRangedWeapon(CrosshairContext context) {
        ItemStack itemStack = context.getItemStack();
        Item handItem = itemStack.m_41720_();
        if (DynamicCrosshair.config.dynamicCrosshairHoldingRangedWeapon() == UsableCrosshairPolicy.Always) {
            if (DynamicCrosshair.config.getAdditionalRangedWeapons().contains(handItem)) {
                return Crosshair.RANGED_WEAPON;
            }
            return switch (handItem.m_6164_(itemStack)) {
                case UseAnim.BOW, UseAnim.CROSSBOW, UseAnim.SPEAR -> Crosshair.RANGED_WEAPON;
                default -> null;
            };
        }
        if (handItem.m_6164_(itemStack) == UseAnim.BOW) {
            float progress;
            if (context.isActiveItem() && (progress = BowItem.m_40661_((int)(handItem.m_8105_(itemStack) - context.player.m_21212_()))) == 1.0f) {
                return Crosshair.RANGED_WEAPON;
            }
            return Crosshair.REGULAR.withFlag(Crosshair.Flag.FixedModifierUse);
        }
        if (handItem.m_6164_(itemStack) == UseAnim.CROSSBOW) {
            if (CrossbowItem.m_40932_((ItemStack)itemStack)) {
                return Crosshair.RANGED_WEAPON;
            }
            return Crosshair.REGULAR.withFlag(Crosshair.Flag.FixedModifierUse);
        }
        if (handItem.m_6164_(itemStack) == UseAnim.SPEAR) {
            int i;
            if (context.isActiveItem() && (i = handItem.m_8105_(itemStack) - context.player.m_21212_()) > 10) {
                return Crosshair.RANGED_WEAPON;
            }
            return null;
        }
        if (DynamicCrosshair.config.getAdditionalRangedWeapons().contains(handItem)) {
            return Crosshair.RANGED_WEAPON;
        }
        return null;
    }

    public static Crosshair checkBlockItem(CrosshairContext context) {
        BlockHitResult boatHitResult;
        Item handItem = context.getItem();
        if (handItem instanceof BlockItem) {
            if (DynamicCrosshair.config.dynamicCrosshairHoldingBlock() == BlockCrosshairPolicy.IfInteractable) {
                if (context.isWithBlock()) {
                    if (context.canPlaceItemAsBlock()) {
                        return Crosshair.HOLDING_BLOCK;
                    }
                    return Crosshair.NONE.withFlag(Crosshair.Flag.FixedModifierUse);
                }
            } else {
                return Crosshair.HOLDING_BLOCK;
            }
        }
        if (handItem instanceof ArmorStandItem) {
            return Crosshair.HOLDING_BLOCK;
        }
        if (handItem instanceof MinecartItem) {
            if (DynamicCrosshair.config.dynamicCrosshairHoldingBlock() == BlockCrosshairPolicy.IfInteractable) {
                if (context.isWithBlock()) {
                    if (context.getBlockState().m_204336_(BlockTags.f_13034_)) {
                        return Crosshair.HOLDING_BLOCK;
                    }
                    return Crosshair.NONE.withFlag(Crosshair.Flag.FixedModifierUse);
                }
            } else {
                return Crosshair.HOLDING_BLOCK;
            }
        }
        if (handItem instanceof EndCrystalItem) {
            if (DynamicCrosshair.config.dynamicCrosshairHoldingBlock() == BlockCrosshairPolicy.IfInteractable) {
                if (context.isWithBlock()) {
                    Block block = context.getBlock();
                    if ((block == Blocks.f_50080_ || block == Blocks.f_50752_) && context.world.m_46859_(context.getBlockPos().m_7494_())) {
                        return Crosshair.HOLDING_BLOCK;
                    }
                    return Crosshair.NONE.withFlag(Crosshair.Flag.FixedModifierUse);
                }
            } else {
                return Crosshair.HOLDING_BLOCK;
            }
        }
        if (handItem instanceof BoatItem && (boatHitResult = context.raycastWithFluid()).m_6662_() == HitResult.Type.BLOCK) {
            return Crosshair.HOLDING_BLOCK;
        }
        return null;
    }
}

